//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainForm.h"
#include <stdio.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)
//#pragma link "Word_2K_SRVR"

#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner)
{
	WordApp = new TWordApplication(0);
	IsProcessing = false;
}
//---------------------------------------------------------------------------

__fastcall TfrmMain::~TfrmMain(void)
{
	delete WordApp;
}
//---------------------------------------------------------------------------

/*
	This function opens up a Word document named Infile, and save is under
	the filename OutFile. If you wanted to do more than just save it, you
	can add calls to Word.
*/
void TfrmMain::UpgradeDocFile(const AnsiString &InFile, const AnsiString& OutFile)
{
		// Everything is a variant. If you've never dealt with variants before
		// read the online help or Google about it.
	OleVariant oleInFile = InFile;
	OleVariant oleOutFile = OutFile;
	OleVariant oleFileFormat = wdWordDocument;
	OleVariant oleSaveChanges = false;

		// How to connect to the server?
	if (chkRunningInstance->Checked && chkNewInstance->Checked)
		WordApp->ConnectKind = ckRunningOrNew;
	else if (chkRunningInstance->Checked)
		WordApp->ConnectKind = ckRunningInstance;
	else if (chkNewInstance->Checked)
		WordApp->ConnectKind = ckNewInstance;
	else
		WordApp->ConnectKind = ckRunningOrNew; // if nothing is checked

	try
	{
			// Connect to the Word server. This will throw an exception if the
			// ConnectKind is ckRunningInstance and there isn't one already
			// running.
		WordApp->Connect();

			// If we're re-using an existing instance, don't mess with it
		if (WordApp->ConnectKind != ckRunningInstance)
			WordApp->Visible = chkShowWord->Checked;

		Application->ProcessMessages(); // yield

			// Open a Word document. See the online help for the meaning
			// of the parameters.
		WordApp->Documents->Open(oleInFile, EmptyParam, EmptyParam, EmptyParam,
														 EmptyParam, EmptyParam, EmptyParam, EmptyParam,
														 EmptyParam, EmptyParam, EmptyParam, EmptyParam);

		Application->ProcessMessages(); // yield

		/*
			If you wanted to read stuff from the document or change/ add
			stuff, you would do it here.
		*/

			// Save the document under a different name. See the online help
			// for the meaning of the parameters.
		WordApp->ActiveDocument->SaveAs(oleOutFile, oleFileFormat, EmptyParam,
																		EmptyParam, EmptyParam, EmptyParam, EmptyParam,
																		EmptyParam, EmptyParam, EmptyParam, EmptyParam);

		Application->ProcessMessages(); // yield

			// Close the document
		WordApp->ActiveDocument->Close(oleSaveChanges, EmptyParam, EmptyParam);

			// Unload the server only if we may have created it.
		if ( (!chkKeepWord->Checked) && (WordApp->ConnectKind != ckRunningInstance) )
		{
			WordApp->Quit();
			WordApp->Disconnect();
		}
	}
	catch (const EOleSysError&)
	{
		ShowMessage("Server threw an exception.");
	}

	Application->ProcessMessages(); // yield
}

void __fastcall TfrmMain::btnProcessClick(TObject *Sender)
{
		// Don't want this function to be re-entrant
	if (!IsProcessing)
	{
		btnProcess->Caption = "Stop";
		IsProcessing = true;
	}
	else
	{
		IsProcessing = false;
		btnProcess->Enabled = false;
		return;
	}

		// Empty the list boxes
	lstInputFiles->Clear();
	lstOutputFiles->Clear();

		// Get number of documents
	int count = spnDocumentCount->Position;

		// Update progress bar's Max value
	barProgress->Max = count;

		// For each document
	for (int i = 1; i <= count; i++)
	{
		char inbuf[MAX_PATH];
		char outbuf[MAX_PATH];

			// Format input and output filenames
		sprintf(inbuf, "../docs/%02d.doc", i);
		sprintf(outbuf, "../docs/XXX-%02d.doc", i);

			// Get the fully-qualified filenames (i.e. full paths)
		AnsiString infile = ExpandFileName(inbuf);
		AnsiString outfile = ExpandFileName(outbuf);

			// Update labels
		lblInputFilename->Caption = infile;
		lblOutputFilename->Caption = outfile;

			// Add to the list boxes
		lstInputFiles->Items->Add(infile);
		lstOutputFiles->Items->Add(outfile);

		Application->ProcessMessages(); // yield

			// Sanity check before processing
		if (FileExists(infile))
			UpgradeDocFile(infile, outfile);

			// Update the progress bar
		barProgress->Position = i;

			// The user pressed the stop button
		if (!IsProcessing)
			break;
	}

		// Reset the state of the button
	btnProcess->Caption = "Process";
	btnProcess->Enabled = true;

		// Done processing
	IsProcessing = false;
	Application->ProcessMessages(); // yield
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
	pgeMain->Align = alClient;
	lstInputFiles->Align = alClient;
	lblInputFilename->Caption = "";
	lblOutputFilename->Caption = "";
	Width = 800;
	Height = 600;
}
//---------------------------------------------------------------------------

/*
function TOleServer.GetServer: IUnknown;
var
	HR: HResult;
	ErrorStr: string;
begin
	case ConnectKind of
		ckNewInstance:
			Result := CreateComObject(FServerData^.ClassId);

		ckRunningInstance:
		begin
			HR := GetActiveObject(FServerData^.ClassId, nil, Result);
			if not Succeeded(HR) then
			begin
				ErrorStr := Format(sNoRunningObject, [ClassIDToProgID(FServerData^.ClassId),
																							GuidToString(FServerData^.ClassId)]);
				raise EOleSysError.Create(ErrorStr, HR, 0);
			end;
		end;

		ckRunningOrNew:
			if not Succeeded(GetActiveObject(FServerData^.ClassId, nil, Result)) then
				Result := CreateComObject(FServerData^.ClassId);

		ckRemote:
			{Highly inefficient: requires at least two round trips - GetClassObject + QI}
			Result := CreateRemoteComObject(RemoteMachineName, FServerData^.ClassID);
	end;
end;
*/
