//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "DrawMainForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner)
{
  color_ = pboxDraw->Canvas->Pen->Color;
  drawing_ = false;
  stroke_num_ = -1;
}
//---------------------------------------------------------------------------

__fastcall TfrmMain::~TfrmMain(void)
{
  ClearDrawing();
}
//---------------------------------------------------------------------------

void TfrmMain::Redraw(void)
{
    // For each 'stroke' in the vector
  for (unsigned int i = 0; i < strokes_.size(); i++)
  {
      // Get the stroke
    std::vector<DrawPoint> *pts = strokes_[i];

      // Set the color of this stroke
    pboxDraw->Canvas->Pen->Color = (*pts)[i].color;

      // Get x and y coordinates
    int x = (*pts)[i].x;
    int y = (*pts)[i].y;

      // Move there
    pboxDraw->Canvas->MoveTo(x, y);

      // For each point remaining, draw a line to it
    for (unsigned int j = 0; j < (*pts).size(); j++)
      pboxDraw->Canvas->LineTo((*pts)[j].x, (*pts)[j].y);
  }

    // Reset the color
  pboxDraw->Canvas->Pen->Color = color_;
}
//---------------------------------------------------------------------------

void TfrmMain::ClearDrawing(void)
{
  for (unsigned i = 0; i < strokes_.size(); i++)
    delete strokes_[i];

  strokes_.clear();
  stroke_num_ = -1;
  pboxDraw->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  imgBackground->Align = alClient;
  pboxDraw->Align = alClient;
  webBrowser->Align = alClient;
  pboxGDI->Align = alClient;
  pnlGDI->Align = alClient;
  pgeMain->Align = alClient;
  shtDraw->DoubleBuffered = true;
  shtBrowser->DoubleBuffered = true;
  webBrowser->DoubleBuffered = true;
  pgeMain->DoubleBuffered = true;
  pnlGDI->DoubleBuffered = true;

  pgeMain->ActivePageIndex = 0;
  Width = 800;
  Height = 600;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::pboxDrawMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
    // Triggers the start of drawing
  if (Button == mbLeft)
  {
    ++stroke_num_;
    pboxDraw->Canvas->MoveTo(X, Y);
    strokes_.push_back(new std::vector<DrawPoint>);
    strokes_[stroke_num_]->push_back(DrawPoint(X, Y, pboxDraw->Canvas->Pen->Color));
    drawing_ = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::pboxDrawMouseMove(TObject *Sender, TShiftState Shift, int X, int Y)
{
    // Add the new mouse postion to the vector
  if (drawing_)
  {
    pboxDraw->Canvas->Pen->Width = 5;
    pboxDraw->Canvas->LineTo(X, Y);
    strokes_[stroke_num_]->push_back(DrawPoint(X, Y, pboxDraw->Canvas->Pen->Color));
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::pboxDrawMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
    // Triggers the end of drawing
  drawing_ = false;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::pboxDrawPaint(TObject *Sender)
{
  Redraw();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuDrawColorCustomClick(TObject *Sender)
{
  if (dlgColor->Execute())
  {
    color_ = dlgColor->Color;
    pboxDraw->Canvas->Pen->Color = color_;
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuDrawClearClick(TObject *Sender)
{
  ClearDrawing();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnGoClick(TObject *Sender)
{
  webBrowser->Navigate(lstURLs->Text);
}
//---------------------------------------------------------------------------


void __fastcall TfrmMain::mnuDrawColorRedClick(TObject *Sender)
{
  pboxDraw->Canvas->Pen->Color = clRed;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuDrawColorGreenClick(TObject *Sender)
{
  pboxDraw->Canvas->Pen->Color = clGreen;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuDrawColorBlueClick(TObject *Sender)
{
  pboxDraw->Canvas->Pen->Color = clBlue;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::lstURLsKeyPress(TObject *Sender, char &Key)
{
  if (Key == VK_RETURN)
  {
    btnGo->Click();
    Key = 0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::lstURLsClick(TObject *Sender)
{
  btnGo->Click();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::pboxGDIPaint(TObject *Sender)
{
    // Paint the entire box black
  pboxGDI->Canvas->Pen->Color = clBlack;
  pboxGDI->Canvas->Brush->Color = clBlack;
  pboxGDI->Canvas->Rectangle(0, 0, pboxGDI->Width, pboxGDI->Height);

    // White ellipse, filled with red
  pboxGDI->Canvas->Pen->Color = clWhite;
  pboxGDI->Canvas->Pen->Width = 5;
  pboxGDI->Canvas->Brush->Color = clRed;
  pboxGDI->Canvas->Ellipse(20, 100, 200, 300);

  int i, step = spnGridSpacing->Position;
  pboxGDI->Canvas->Pen->Width = 1;
  pboxGDI->Canvas->Pen->Color = clBlue;

    // Draw thin, blue, horizontal lines
  for (i = 0; i < pboxGDI->Height; i += step)
  {
    pboxGDI->Canvas->MoveTo(0, i);
    pboxGDI->Canvas->LineTo(pboxGDI->Width, i);
  }

    // Draw thin, blue, vertical lines
  for (i = 0; i < pboxGDI->Width; i += step)
  {
    pboxGDI->Canvas->MoveTo(i, 0);
    pboxGDI->Canvas->LineTo(i, pboxGDI->Height);
  }

}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::edtGridSpacingChange(TObject *Sender)
{
  pboxGDI->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnHomeClick(TObject *Sender)
{
  try
  {
    webBrowser->Navigate("http://azrael.digipen.edu/~mmead/www/public/RAD2009/");
  }
  catch(...)
  {
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnBackClick(TObject *Sender)
{
  try
  {
    webBrowser->GoBack();
  }
  catch(...)
  {
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnForwardClick(TObject *Sender)
{
  try
  {
    webBrowser->GoForward();
  }
  catch(...)
  {
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnReloadClick(TObject *Sender)
{
  try
  {
    webBrowser->Refresh();
  }
  catch(...)
  {
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::webBrowserBeforeNavigate2(TObject *ASender,
      const IDispatch *pDisp, OleVariant &URL, OleVariant &Flags,
      OleVariant &TargetFrameName, OleVariant &PostData, OleVariant &Headers,
      WordBool &Cancel)
{
  AnsiString s = (AnsiString &)URL;
  lstURLs->Text = s;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::webBrowserNavigateComplete2(TObject *ASender,
      const IDispatch *pDisp, OleVariant &URL)
{
  lstURLs->Text = webBrowser->LocationURL;
}
//---------------------------------------------------------------------------

