//---------------------------------------------------------------------------

#ifndef DrawMainFormH
#define DrawMainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
#include <ImgList.hpp>
#include <Graphics.hpp>
#include <SHDocVw.hpp>
#include <OleCtrls.hpp>

//---------------------------------------------------------------------------
#include <vector>
struct DrawPoint
{
  DrawPoint(int X, int Y, TColor c) : x(X), y(Y), color(c) {};
  int x;
  int y;
  TColor color;
};

class TfrmMain : public TForm
{
__published:  // IDE-managed Components
  TPageControl *pgeMain;
  TTabSheet *shtDraw;
  TTabSheet *shtBrowser;
  TPaintBox *pboxDraw;
  TColorDialog *dlgColor;
  TImageList *lstImages;
  TImage *imgBackground;
  TPopupMenu *popDraw;
  TMenuItem *mnuDrawColor;
  TMenuItem *N1;
  TMenuItem *mnuDrawClear;
  TMenuItem *mnuDrawColorRed;
  TMenuItem *mnuDrawColorGreen;
  TMenuItem *mnuDrawColorBlue;
  TMenuItem *mnuDrawColorCustom;
  TMenuItem *N2;
  TStatusBar *StatusBar1;
  TPanel *pnlBrowser;
  TButton *btnGo;
  TComboBox *lstURLs;
  TTabSheet *shtGDI;
  TPanel *pnlBottom;
  TLabel *Label1;
  TEdit *edtGridSpacing;
  TUpDown *spnGridSpacing;
  TPanel *pnlGDI;
  TPaintBox *pboxGDI;
  TWebBrowser *webBrowser;
  TToolBar *ToolBar1;
  TToolButton *btnHome;
  TToolButton *btnBack;
  TToolButton *btnForward;
  TToolButton *btnReload;
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall pboxDrawMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
  void __fastcall pboxDrawMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall pboxDrawMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall pboxDrawPaint(TObject *Sender);
  void __fastcall mnuDrawColorCustomClick(TObject *Sender);
  void __fastcall mnuDrawClearClick(TObject *Sender);
  void __fastcall btnGoClick(TObject *Sender);
  void __fastcall mnuDrawColorRedClick(TObject *Sender);
  void __fastcall mnuDrawColorGreenClick(TObject *Sender);
  void __fastcall mnuDrawColorBlueClick(TObject *Sender);
  void __fastcall lstURLsKeyPress(TObject *Sender, char &Key);
  void __fastcall lstURLsClick(TObject *Sender);
  void __fastcall pboxGDIPaint(TObject *Sender);
  void __fastcall edtGridSpacingChange(TObject *Sender);
  void __fastcall btnHomeClick(TObject *Sender);
  void __fastcall btnBackClick(TObject *Sender);
  void __fastcall btnForwardClick(TObject *Sender);
  void __fastcall btnReloadClick(TObject *Sender);
  void __fastcall webBrowserBeforeNavigate2(TObject *ASender,
          const IDispatch *pDisp, OleVariant &URL, OleVariant &Flags,
          OleVariant &TargetFrameName, OleVariant &PostData,
          OleVariant &Headers, WordBool &Cancel);
  void __fastcall webBrowserNavigateComplete2(TObject *ASender,
          const IDispatch *pDisp, OleVariant &URL);
private:
  bool drawing_;
  std::vector<std::vector<DrawPoint>* > strokes_;
  int stroke_num_;
  TColor color_;
  void Redraw(void);
  void ClearDrawing(void);
public:
  __fastcall TfrmMain(TComponent* Owner);
  __fastcall ~TfrmMain(void);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmMain *frmMain;
//---------------------------------------------------------------------------
#endif
