//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainForm.h"
#include "CoolForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
	Width = 500;
	Height = 510;
	pgeMain->Align = alClient;
	pnlMovie->Align = alClient;
	imgAlbumCover->Align = alClient;
	shtMusic->DoubleBuffered = true;
	shtMovie->DoubleBuffered = true;
	pnlMovie->DoubleBuffered = true;
	dtpToday->Date = Now();
}
//---------------------------------------------------------------------------

//******************************************************************************
//******************************************************************************
//******************************************************************************
// TToolBar stuff
//******************************************************************************

/*
	When we dock on the top panel, make sure to resize it so it is visible.
*/
void __fastcall TfrmMain::pnlTop1DockDrop(TObject *Sender, TDragDockObject *Source,	int X, int Y)
{
	pnlTop1->AutoSize = false;
	pnlTop1->Height = 50;
}
//---------------------------------------------------------------------------

/*
	When we move a toolbar off of a panel, make sure the panel hides itself.
*/
void __fastcall TfrmMain::barTools1StartDock(TObject *Sender,	TDragDockObject *&DragObject)
{
	pnlTop1->AutoSize = true;
	pnlLeft->AutoSize = true;
}
//---------------------------------------------------------------------------

/*
	When we dock on the left panel, make sure to resize it so it is visible.
*/
void __fastcall TfrmMain::pnlLeftDockDrop(TObject *Sender, TDragDockObject *Source, int X, int Y)
{
	pnlLeft->AutoSize = false;
	pnlLeft->Width = 150;
}
//---------------------------------------------------------------------------


//******************************************************************************
//******************************************************************************
//******************************************************************************
// TCoolBar stuff
//******************************************************************************

void __fastcall TfrmMain::btnShowToolsClick(TObject *Sender)
{
	barTools1->Show();
	barTools2->Show();
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnHideToolsClick(TObject *Sender)
{
	barTools1->Hide();
	barTools2->Hide();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::barTools2StartDock(TObject *Sender,	TDragDockObject *&DragObject)
{
	pnlTop1->AutoSize = true;
	pnlLeft->AutoSize = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnShowFormClick(TObject *Sender)
{
	frmCool->Show();
}
//---------------------------------------------------------------------------

//******************************************************************************
//******************************************************************************
//******************************************************************************
// TMediaPlayer stuff
//******************************************************************************

void __fastcall TfrmMain::pnlMovieResize(TObject *Sender)
{
	if (!chkStretch->Checked)
		return;

	TRect rect = pnlMovie->ClientRect;
	rect.Bottom = rect.Bottom - 2;
	rect.Right = rect.Right -2;
	mpMovie->DisplayRect = rect;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnOpenWAVClick(TObject *Sender)
{
	dlgFileOpen->Filter = "WAV Files;*.wav";
	dlgFileOpen->DefaultExt = "*.wav";
	if (dlgFileOpen->Execute())
	{
		mpWAV->FileName = dlgFileOpen->FileName;
		mpWAV->Open();
	}
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnOpenMovieClick(TObject *Sender)
{
	dlgFileOpen->Filter = "AVI Files;*.avi";
	dlgFileOpen->DefaultExt = "*.avi";
	if (dlgFileOpen->Execute())
	{
		mpMovie->FileName = dlgFileOpen->FileName;
		mpMovie->Display = 0; // separate window
		mpMovie->Open();
	}

		// If the movie should be embedded, put it on the panel
	if (chkEmbedded->Checked)
	{
		mpMovie->Display = pnlMovie;
		chkStretchClick(Sender);
	}
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::chkStretchClick(TObject *Sender)
{
	TRect rect;

		// Adjust rect to show bevels
	if (chkStretch->Checked)
	{
		rect = pnlMovie->ClientRect;
		rect.Bottom = rect.Bottom - 2;
		rect.Right = rect.Right - 2;
		rect.Top = 2;
		rect.Left = 2;
	}
	else // some arbitrary size
	{
		rect.Bottom = 241;
		rect.Right = 321;
		rect.Left = 2;
		rect.Top = 2;
	}
	mpMovie->DisplayRect = rect;
}
//---------------------------------------------------------------------------


//******************************************************************************
//******************************************************************************
//******************************************************************************
// TScrollBox stuff
//******************************************************************************

void __fastcall TfrmMain::btnPopulateClick(TObject *Sender)
{
	static int bcount = 1;
	sboxButtons->VertScrollBar->Position = 0;
	int t = sboxButtons->ComponentCount * (25 + 5);
	for (int i = 0; i < 10; i++)
	{
		TButton *b = new TButton(sboxButtons); // owner deletes the button
		b->Parent = sboxButtons;               // parent paints the button
		b->Top = t;
		b->Left = 10;
		b->Caption = Format("Button %d", ARRAYOFCONST((bcount)));
		bcount++;
		t += b->Height + 5;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::barScrollSizeChange(TObject *Sender)
{
	sboxButtons->VertScrollBar->Increment = (short)barScrollSize->Position;
}
//---------------------------------------------------------------------------

