//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------

/*
	Constructor.
*/
__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------

/*
	Event for the form's creation. (OnCreate)
*/
void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
		// The usual stuff
	pgeMain->Align = alClient;
	pnlMain->Align = alClient;

		// Make sure that the first tab is showing. The default behavior is to
		// show the tab that was active during design.
	pgeMain->ActivePageIndex = 0;
}
//---------------------------------------------------------------------------

/*
	Event handler for the OnChange event of any edit box.
*/
void __fastcall TfrmMain::ColorChange(TObject *Sender)
{
		// Read the values from the edit boxes. (The text is AnsiString)
	int red = StrToInt(ledtRed->Text);
	int green = StrToInt(ledtGreen->Text);
	int blue = StrToInt(ledtBlue->Text);

		// Set the panel's color to the values of the edit boxes
	pnlMain->Color = TColor(RGB(red, green, blue));

		// Synchronize the sliders with the edit box values
	barRed->Position = red;
	barGreen->Position = green;
	barBlue->Position = blue;
}
//---------------------------------------------------------------------------

/*
	Event handler when any of the sliders moves (OnChange event)
*/
void __fastcall TfrmMain::ColorSlides(TObject *Sender)
{
	spnRed->Position = short(barRed->Position);
	spnGreen->Position = short(barGreen->Position);
	spnBlue->Position = short(barBlue->Position);
}
//---------------------------------------------------------------------------

/*
	Event handler for the OnChange event of the alpha blending slider
*/
void __fastcall TfrmMain::barAlphaBlendChange(TObject *Sender)
{
		// Update the form's AlphaBlend property. (Transparency)
	AlphaBlendValue = (unsigned char)barAlphaBlend->Position;
}
//---------------------------------------------------------------------------

