//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
//---------------------------------------------------------------------------

const int MaxRows = 201;
const int MaxColumns = 201;

class TRNStuff : public TForm
{
__published:	// IDE-managed Components
	TStatusBar *StatusBar1;
	TToolBar *barMainTools;
	TToolButton *btn800x600;
	TPageControl *pgePier;
	TTabSheet *shtPier;
	TToolButton *btn1024x768;
	TToolButton *btnStep;
	TTimer *Timer1;
	TToolButton *btnRun;
	TPanel *pnlPier;
	TDrawGrid *gridPier;
	TPanel *pnlWaterLeft;
	TPanel *pnlWaterBottom;
	TPanel *pnlWaterRight;
	TPanel *pnlBeach;
	TToolButton *btnReset;
	TPanel *pnlControls;
	TUpDown *spnRows;
	TUpDown *spnColumns;
	TEdit *edtRows;
	TEdit *edtColumns;
	TLabel *lblRows;
	TLabel *lblColumns;
	TLabel *lblCurrentRow_;
	TLabel *lblCurrentColumn_;
	TLabel *lblCurrentRow;
	TLabel *lblCurrentColumn;
	TLabel *lblSteps_;
	TLabel *lblTotalSteps;
	TEdit *edtForward;
	TUpDown *spnForward;
	TEdit *edtBack;
	TUpDown *spnBack;
	TEdit *edtLeft;
	TUpDown *spnLeft;
	TEdit *edtRight;
	TUpDown *spnRight;
	TSplitter *splitBottom;
	TLabel *lblStepDirection;
	TSpeedButton *btnResetValues;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall shtPierResize(TObject *Sender);
	void __fastcall OnCellCountChange(TObject *Sender);
	void __fastcall OnPercentageChange(TObject *Sender);
	void __fastcall btn800x600Click(TObject *Sender);
	void __fastcall btn1024x768Click(TObject *Sender);
	void __fastcall btnStepClick(TObject *Sender);
	void __fastcall Timer1Timer(TObject *Sender);
	void __fastcall gridPierDrawCell(TObject *Sender, int ACol, int ARow,
					TRect &Rect, TGridDrawState State);
	void __fastcall btnRunClick(TObject *Sender);
	void __fastcall btnResetClick(TObject *Sender);
	void __fastcall gridPierSelectCell(TObject *Sender, int ACol, int ARow,
					bool &CanSelect);
	void __fastcall splitBottomMoved(TObject *Sender);
	void __fastcall btnResetValuesClick(TObject *Sender);

private:	// User declarations
	int CellWidth;
	int CellHeight;
	int Rows;
	int Columns;

	int CellState[MaxRows][MaxColumns];
	int FreqForward;
	int FreqBack;
	int FreqLeft;
	int FreqRight;

	int RowStart, ColumnStart;
	int RowCurr, ColumnCurr;
	int TotalSteps;
	int RangeF, RangeFB, RangeFBL;

	void Init(void);
	void EnableGrid(bool enable);
	void AdjustGrid(void);
	void UpdateCurrentCell(void);
	void TakeStep(void);

public:		// User declarations
	__fastcall TRNStuff(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TRNStuff *RNStuff;
//---------------------------------------------------------------------------
#endif
