//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <ImgList.hpp>
#include <ActnList.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include <Graphics.hpp>
//---------------------------------------------------------------------------

enum CELL_TYPE {ctEMPTY, ctOBSTACLE, ctCHARACTER, ctENEMY, ctPRIZE};

struct ColorID
{
	CELL_TYPE type;
	TColor color;
};

class TfrmMain : public TForm
{
__published:	// IDE-managed Components
	TStatusBar *barStatus;
	TPageControl *pgeWorld;
	TTabSheet *shtPier;
	TPanel *pnlWorld;
	TDrawGrid *gridWorld;
	TPanel *pnlBottom;
	TSplitter *splitHorizontal;
	TMemo *mmoStatus;
	TToolBar *barColors;
	TToolButton *btnEmpty;
	TToolButton *btnObstacle;
	TToolButton *btnCharacter;
	TToolButton *btnEnemy;
	TToolButton *btnPrize;
	TImageList *lstImages;
	TActionList *lstActions;
	TMainMenu *mnuMain;
	TAction *actFileOpen;
	TAction *actFileSave;
	TAction *actFileNew;
	TAction *actFileExit;
	TAction *actFileSaveAs;
	TMenuItem *mnuFile;
	TMenuItem *mnuFileNew;
	TMenuItem *mnuFileOpen;
	TMenuItem *mnuFileSave;
	TMenuItem *mnuFileSaveAs;
	TMenuItem *N1;
	TMenuItem *mnuFileExit;
	TLabel *lblRows;
	TEdit *edtRows;
	TUpDown *spnRows;
	TLabel *lblColumns;
	TEdit *edtColumns;
	TUpDown *spnColumns;
	TOpenDialog *dlgFileOpen;
	TSaveTextFileDialog *dlgFileSaveText;
	TToolBar *barMainTools;
	TToolButton *btnFileNew;
	TToolButton *btnFileOpen;
	TToolButton *btnFileSave;
	TToolButton *btnFileSaveAs;
	TToolButton *ToolButton10;
	TImageList *lstColors;
	TToolButton *btnTest;
	TAction *actTest;
	TAction *actShowGrid;
	TToolButton *btnDUMMY;
	TToolButton *btnGrid;
	TImage *imgPrize;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall shtPierResize(TObject *Sender);
	void __fastcall OnCellCountChange(TObject *Sender);
	void __fastcall gridWorldDrawCell(TObject *Sender, int ACol, int ARow, TRect &Rect, TGridDrawState State);
	void __fastcall gridWorldSelectCell(TObject *Sender, int ACol, int ARow, bool &CanSelect);
	void __fastcall splitHorizontalMoved(TObject *Sender);
	void __fastcall gridWorldMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall gridWorldMouseLeave(TObject *Sender);
	void __fastcall gridWorldMouseEnter(TObject *Sender);
	void __fastcall ColorChange(TObject *Sender);
	void __fastcall actFileOpenExecute(TObject *Sender);
	void __fastcall actFileSaveExecute(TObject *Sender);
	void __fastcall actTestExecute(TObject *Sender);
	void __fastcall actFileNewExecute(TObject *Sender);
	void __fastcall actShowGridExecute(TObject *Sender);
private:
		// Some limitations (for now)
	static const int FMaxRows = 201;
	static const int FMaxColumns = 201;

	int FDataMap[FMaxRows][FMaxColumns];  // Hold the values of the cells

	int FCellWidth;  // Width of a grid cell
	int FCellHeight; // Heigth of a grid cell
	short FRows;     // Number of rows in the grid
	short FColumns;  // Number of columns in the grid
	int FCurrRow;    // Currently selected row
	int FCurrColumn; // Currently selected column
	int FPrevRow;    // Previously selected row
	int FPrevColumn; // Previously selected column

	bool FOffGrid;        // mouse on/off the grid
	bool FShowGrid;       // Grid lines on/off
	TColor FGridColor;    // Color of the grid lines
	ColorID FCurrColorID; // Currently selected color (type)

	AnsiString FCurrFileName; // The filename to save the data to

	void Init(void);
	void AdjustGrid(void);
	void UpdateCurrentCellDisplay(void);
	void AddStatus(const char *text);
	void HighlightCell(void);

	bool ImportMapData(const AnsiString &FileName);
	bool ExportMapData(const AnsiString &FileName);

public:
	__fastcall TfrmMain(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmMain *frmMain;
//---------------------------------------------------------------------------
#endif
