//---------------------------------------------------------------------------

#ifndef WBMainH
#define WBMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
//---------------------------------------------------------------------------

#include "WarBoats.h"
#include "Ocean.h"

class TWarBoatsForm : public TForm
{
__published:	// IDE-managed Components
	TStatusBar *StatusBar1;
	TToolBar *ToolBar1;
	TPageControl *pgePier;
	TTabSheet *shtPier;
	TToolButton *btnNewGame;
	TPanel *pnlPier;
	TDrawGrid *gridPier;
	TPanel *pnlWaterBottom;
	TLabel *Label8;
	TLabel *Label9;
	TLabel *lblCurrentRow;
	TLabel *lblCurrentColumn;
	TLabel *Label11;
	TLabel *lblShotsTaken;
	TSplitter *splitHorizontal;
	TLabel *lblStepDirection;
	TPanel *Panel1;
	TLabel *Label6;
	TLabel *Label7;
	TUpDown *spnRows;
	TUpDown *spnColumns;
	TEdit *edtRows;
	TEdit *edtColumns;
	TMemo *mmoStatus;
	TUpDown *spnBoats;
	TEdit *edtBoats;
	TLabel *Label1;
	TLabel *lblBoatsRemaining;
	TCheckBox *chkCheats;
	TCheckBox *chkSound;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall shtPierResize(TObject *Sender);
	void __fastcall OnCellCountChange(TObject *Sender);
	void __fastcall btnNewGameClick(TObject *Sender);
	void __fastcall gridPierDrawCell(TObject *Sender, int ACol, int ARow,
					TRect &Rect, TGridDrawState State);
	void __fastcall gridPierSelectCell(TObject *Sender, int ACol, int ARow,
					bool &CanSelect);
	void __fastcall splitHorizontalMoved(TObject *Sender);
	void __fastcall gridPierMouseMove(TObject *Sender, TShiftState Shift, int X,
					int Y);
	void __fastcall FormKeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall gridPierMouseLeave(TObject *Sender);
	void __fastcall gridPierMouseEnter(TObject *Sender);
	void __fastcall chkCheatsClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
private:

	static const int MaxRows = 201;
	static const int MaxColumns = 201;
	int CellState[MaxRows][MaxColumns];

	CS170::WarBoats::Ocean *theOcean; // The Ocean from CS170
	int CellWidth;     // Width of a grid cell
	int CellHeight;    // Heigth of a grid cell
	int Rows;          // Number of rows in the grid
	int Columns;       // Number of columns in the grid
	int NumBoats;      // Number of boats in the grid
	int SunkBoats;     // Number of boats that were sunk
	int ShotsTaken;    // Number of shots taken thus far
	bool GameOver;     // All boats sunk?
	bool OffGrid;      // mouse on/off the grid
	bool BoatsVisible; // cheats on/off

	int RowCurr, ColumnCurr;
	int RowPrev, ColumnPrev;

	void Init(void);
	void AdjustGrid(void);
	void UpdateCurrentCell(void);
	void TakeShot(void);
	void CopyGrid(void);
	void AddStatus(const char *text);
	void UpdateDisplay(void);
	void SetupBoatsRand(int num_boats, int xsize, int ysize);
	void HighlightCell(void);
	void ShowBoats(bool OnOff);

	void PlayGameSound(CS170::WarBoats::ShotResult hittype);

public:
	__fastcall TWarBoatsForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TWarBoatsForm *WarBoatsForm;
//---------------------------------------------------------------------------
#endif
