//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainForm.h"
#include <IniFiles.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------

/*
	Constructor
*/
__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner), ConfigFilename_("./MyProgram.ini")
{
}
//---------------------------------------------------------------------------

/*
	Reads program settings from an .ini file
*/
void TfrmMain::LoadConfig(const AnsiString &Filename)
{
	TIniFile *inifile = new TIniFile(ConfigFilename_);

		Width = inifile->ReadInteger("General", "Width", 365);
		Height = inifile->ReadInteger("General", "Height", 285);
		Top = inifile->ReadInteger("General", "Top", 60);
		Left = inifile->ReadInteger("General", "Left", 60);

		edtTitle->Text = inifile->ReadString("General", "Title", "Default");
		edtDescription->Text = inifile->ReadString("General", "Description", "Default");

		rgrpMap->ItemIndex = inifile->ReadInteger("Level", "Map", 0);
		chkSpectre->Checked = inifile->ReadBool("Level", "Spectre", False);
		chkArachnotron->Checked = inifile->ReadBool("Level", "Arachnotron", False);
		chkMancubus->Checked = inifile->ReadBool("Level", "Mancubus", False);
		spnNumSpectre->Position = (short)inifile->ReadInteger("Level", "SpectreCount", 1);
		spnNumArachnotron->Position = (short)inifile->ReadInteger("Level", "ArachnotronCount", 1);
		spnNumMancubus->Position = (short)inifile->ReadInteger("Level", "MancubusCount", 1);

	delete inifile;
}

/*
	Writes settings to an .ini file
*/
void TfrmMain::SaveConfig(const AnsiString &Filename)
{
	TIniFile *inifile = new TIniFile(ConfigFilename_);

		inifile->WriteInteger("General", "Width", Width);
		inifile->WriteInteger("General", "Height", Height);
		inifile->WriteInteger("General", "Top", Top);
		inifile->WriteInteger("General", "Left", Left);

		inifile->WriteString("General", "Title", edtTitle->Text);
		inifile->WriteString("General", "Description", edtDescription->Text);

		inifile->WriteInteger("Level", "Map", rgrpMap->ItemIndex);
		inifile->WriteBool("Level", "Spectre", chkSpectre->Checked);
		inifile->WriteBool("Level", "Arachnotron", chkArachnotron->Checked);
		inifile->WriteBool("Level", "Mancubus", chkMancubus->Checked);
		inifile->WriteInteger("Level", "SpectreCount", spnNumSpectre->Position);
		inifile->WriteInteger("Level", "ArachnotronCount", spnNumArachnotron->Position);
		inifile->WriteInteger("Level", "MancubusCount", spnNumMancubus->Position);

	delete inifile;
}

void __fastcall TfrmMain::btnLoadClick(TObject *Sender)
{
	LoadConfig(ConfigFilename_);
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormClose(TObject *Sender, TCloseAction &Action)
{
	SaveConfig(ConfigFilename_);
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnSaveClick(TObject *Sender)
{
	SaveConfig(ConfigFilename_);
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
	LoadConfig(ConfigFilename_);
}
//---------------------------------------------------------------------------

