//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ConfigForm.h"
#include "MainForm.h"
#include <IniFiles.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmConfig *frmConfig;
//---------------------------------------------------------------------------
__fastcall TfrmConfig::TfrmConfig(TComponent* Owner) : TForm(Owner)
{
	FConfigFilename = "PEConfig.ini";
}
//---------------------------------------------------------------------------

void TfrmConfig::LoadSettings(void)
{
		// TMemIniFile is a buffered ini file
	AnsiString filename = ExtractFilePath(ParamStr(0)) + FConfigFilename;
	TMemIniFile *inifile = new TMemIniFile(filename);
	try
	{
		GameExecutable = inifile->ReadString("Programs", "GameExecutable", "");

		GridEnabled = inifile->ReadBool("General", "GridEnabled", 0);
		DefaultRowCount = (short)inifile->ReadInteger("General", "DefaultRowCount", DEFAULT_ROW_COUNT);
		DefaultColCount = (short)inifile->ReadInteger("General", "DefaultColCount", DEFAULT_COL_COUNT);
		frmMain->Left = inifile->ReadInteger("General", "MainWindowLeft", 50);
		frmMain->Top = inifile->ReadInteger("General", "MainWindowTop", 50);
		frmMain->Width = inifile->ReadInteger("General", "MainWindowWidth", 700);
		frmMain->Height = inifile->ReadInteger("General", "MainWindowHeight", 700);
		FieldsToDialog();
	}
	__finally
	{
		delete inifile;
	}
}

void TfrmConfig::SaveSettings(void)
{
		// TMemIniFile is a buffered ini file
	AnsiString filename = ExtractFilePath(ParamStr(0)) + FConfigFilename;
	TMemIniFile *inifile = new TMemIniFile(filename);
	try
	{
		inifile->WriteString("Programs", "GameExecutable", GameExecutable);

		inifile->WriteBool("General", "GridEnabled", GridEnabled);
		inifile->WriteInteger("General", "DefaultRowCount", DefaultRowCount);
		inifile->WriteInteger("General", "DefaultColCount", DefaultColCount);
		inifile->WriteInteger("General", "MainWindowLeft", frmMain->Left);
		inifile->WriteInteger("General", "MainWindowTop", frmMain->Top);
		inifile->WriteInteger("General", "MainWindowWidth", frmMain->Width);
		inifile->WriteInteger("General", "MainWindowHeight", frmMain->Height);
	}
	__finally
	{
		inifile->UpdateFile(); // Flush the buffer to disk before deleting!!!
		delete inifile;
	}
}

/*
	Copies all of the internal data to the UI components
*/
void TfrmConfig::FieldsToDialog(void)
{
	edtGameExecutable->Text = GameExecutable;
	chkGridEnabled->Checked = GridEnabled;
	spnRows->Position = DefaultRowCount;
	spnColumns->Position = DefaultColCount;

}

/*
	Copies all of the UI values to the internal data
*/
void TfrmConfig::DialogToFields(void)
{
	GameExecutable = edtGameExecutable->Text;
	GridEnabled = chkGridEnabled->Checked;
	DefaultRowCount = (short) StrToInt(edtRows->Text);
	DefaultColCount = (short) StrToInt(edtColumns->Text);

}

//******************************************************************************
// Private settors
//******************************************************************************
void TfrmConfig::SetGameExecutable(const AnsiString &exe)
{
		// Make sure that the file is valid
	if (FileExists(exe))
		FGameExecutable = exe;
	else // otherwise, display an error message
	{
		TMsgDlgButtons btns;
		btns << mbOK;
		MessageDlg(exe + " is not a valid filename", mtError, btns, 0);
	}
}

void TfrmConfig::SetDefaultRowCount(short RowCount)
{
	FDefaultRowCount = RowCount;
}

void TfrmConfig::SetDefaultColCount(short ColCount)
{
	FDefaultColCount = ColCount;
}

//******************************************************************************
//******************************************************************************
//******************************************************************************
// Event Handlers
//******************************************************************************

/*
	Main window creation
*/
void __fastcall TfrmConfig::FormCreate(TObject *Sender)
{
	PageControl1->Align = alClient;
}
//---------------------------------------------------------------------------

/*
	User clicked the browse button
*/
void __fastcall TfrmConfig::btnShowFileDialogClick(TObject *Sender)
{
	if (dlgFileOpen->Execute())
		edtGameExecutable->Text = dlgFileOpen->FileName;
}
//---------------------------------------------------------------------------

/*
	User accepted the changes
*/
void __fastcall TfrmConfig::btnOkClick(TObject *Sender)
{
	DialogToFields(); // Get user changes
	SaveSettings();   // Persist to the disk (.ini file)
}
//---------------------------------------------------------------------------

/*
	User canceled the changes
*/
void __fastcall TfrmConfig::btnCancelClick(TObject *Sender)
{
		// Undo anything the user may have changed
	FieldsToDialog();
}
//---------------------------------------------------------------------------


