//---------------------------------------------------------------------------

#ifndef ConfigFormH
#define ConfigFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ImgList.hpp>
#include <Tabs.hpp>
#include <ButtonGroup.hpp>
#include <CategoryButtons.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TfrmConfig : public TForm
{
__published:	// IDE-managed Components
	TPageControl *PageControl1;
	TTabSheet *TabSheet1;
	TTabSheet *TabSheet2;
	TButton *btnOk;
	TButton *btnCancel;
	TLabel *lblGameExecutable;
	TEdit *edtGameExecutable;
	TButton *btnShowFileDialog;
	TOpenDialog *dlgFileOpen;
	TGroupBox *GroupBox1;
	TCheckBox *chkGridEnabled;
	TLabel *lblRows;
	TEdit *edtRows;
	TUpDown *spnRows;
	TLabel *lblColumns;
	TEdit *edtColumns;
	TUpDown *spnColumns;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall btnShowFileDialogClick(TObject *Sender);
	void __fastcall btnOkClick(TObject *Sender);
	void __fastcall btnCancelClick(TObject *Sender);

private:
	static const short DEFAULT_ROW_COUNT = 20;
	static const short DEFAULT_COL_COUNT = 20;

	AnsiString FConfigFilename; // The name of the .ini file
	AnsiString FGameExecutable; // The name of the CS230 .exe
	bool FGridEnabled;          // Grid lines on/off
	short FDefaultRowCount;     // When creating a new map, default rows
	short FDefaultColCount;     // When creating a new map, default rows

		// Private settors
	void SetGameExecutable(const AnsiString &exe);
	void SetDefaultRowCount(short RowCount);
	void SetDefaultColCount(short ColCount);

	void FieldsToDialog(void); // Copies all of the internal data to the UI components
	void DialogToFields(void); // Copies all of the UI values to the internal data

public:
	__fastcall TfrmConfig(TComponent* Owner);

		// Public properties
	__property AnsiString GameExecutable = {read=FGameExecutable, write=SetGameExecutable};
	__property bool GridEnabled = {read=FGridEnabled, write=FGridEnabled};
	__property short DefaultRowCount = {read=FDefaultRowCount, write=SetDefaultRowCount};
	__property short DefaultColCount = {read=FDefaultColCount, write=SetDefaultColCount};

	void LoadSettings(void);
	void SaveSettings(void);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmConfig *frmConfig;
//---------------------------------------------------------------------------
#endif
