//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

//---------------------------------------------------------------------------

#pragma package(smart_init)

/*
	Adds the dragged items to the end of the list. The source items will not
	be disturbed. This is a "copy" operation as opposed to a "move" operation.
*/
void AddCopyItems(TListBox *Destination, TListBox *Source)
{
		// For each selected item in the source list, add the item
		// to the end of the destination list
	for (int i = 0; i < Source->Count; ++i)
		if (Source->Selected[i])
			Destination->Items->Add(Source->Items->Strings[i]);
}

/*
	Adds the dragged items to the end of the list. After adding the items,
	the source items will be deleted. This is a "move" operation as opposed
	to a "copy" operation.
*/
void AddMoveItems(TListBox *Destination, TListBox *Source)
{
		// Copy the items
	AddCopyItems(Destination, Source);

		// Delete each of the highlighted items from the source list.
		// It's important to delete in reverse order, since we are using
		// indexes (which would be invalidated otherwise).
	for (int i = Source->Items->Count - 1; i >= 0; --i)
		if (Source->Selected[i])
			Source->Items->Delete(i);
}


/*
	Inserts the dragged items at the drop point. The source items will not
	be disturbed. This is a "copy" operation as opposed to a "move" operation.
*/
void InsertCopyItems(TListBox *Destination, TListBox *Source, int X, int Y)
{
		// This is the item that we are dropping on
	int dropIndex = Destination->ItemAtPos(TPoint(X, Y), true);

		// Loop through all of the highlighted items and drop them
	if (dropIndex == -1) // -1 means were dropping after the last one (adding)
	{
		for (int i = 0; i < Source->Count; i++)
			if (Source->Selected[i])
				Destination->Items->Add(Source->Items->Strings[i]);
	}
	else
	{
			// Need to insert in reverse order to preserve the positions
		for (int i = Source->Count - 1; i >= 0; i--)
			if (Source->Selected[i])
				Destination->Items->Insert(dropIndex, Source->Items->Strings[i]);
	}
}

/*
	Inserts the dragged items at the drop point. After inserting the items,
	the source items will be deleted. This is a "move" operation as opposed
	to a "copy" operation.
*/
void InsertMoveItems(TListBox *Destination, TListBox *Source, int X, int Y)
{
		// We are dropping within our own list view, so we'll prevent that
		// If this is something you want, disable this check
	if (Source == Destination)
		return;

		// Copy the items
	InsertCopyItems(Destination, Source, X, Y);

		// Delete each of the highlighted items from the source list.
		// It's important to delete in reverse order, since we are using
		// indexes (which would be invalidated otherwise).
	for (int i = Source->Items->Count - 1; i >= 0; --i)
		if (Source->Selected[i])
			Source->Items->Delete(i);
}

