//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Form1.h"
#include "Form2.h"
#include "DragDropUtils.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmForm1 *frmForm1;
//---------------------------------------------------------------------------

/*
	Constructor
*/
__fastcall TfrmForm1::TfrmForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------

/*
	Test to see if the dragged items can be dropped onto the list.
*/
void __fastcall TfrmForm1::lstBox1DragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
		// Make sure we are accepting from another list box only
	TListBox *lb = dynamic_cast<TListBox *>(Sender);
	if (lb)
		Accept = true;
	else
		Accept = false;
}
//---------------------------------------------------------------------------

/*
	Test to see if the dragged items can be dropped onto the list.
*/
void __fastcall TfrmForm1::lstBox2DragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
		// 	Don't allow this list box to drop onto itself
	if (Sender == Source)
	{
		Accept = false;
		return;
	}

		// Make sure we are accepting from another list box only
	TListBox *lb = dynamic_cast<TListBox *>(Sender);
	if (lb)
		Accept = true;
	else
		Accept = false;
}
//---------------------------------------------------------------------------

/*
	This list box is moving items from another list box and inserting them
	at the drop point.
*/
void __fastcall TfrmForm1::lstBox2DragDrop(TObject *Sender, TObject *Source, int X, int Y)
{
	InsertMoveItems((TListBox *)Sender, (TListBox*)Source, X, Y);
}
//---------------------------------------------------------------------------

/*
	This list box is moving items from another list box and appending them
	to the end of the current list. It doesn't matter where the items are
	dropped, as they will always be appended to the end.
*/
void __fastcall TfrmForm1::lstBox1DragDrop(TObject *Sender, TObject *Source, int X, int Y)
{
	AddMoveItems((TListBox *)Sender, (TListBox *)Source);
}
//---------------------------------------------------------------------------

/*
	Shows the second form.
*/
void __fastcall TfrmForm1::btnShowForm2Click(TObject *Sender)
{
	frmForm2->Show();
}
//---------------------------------------------------------------------------

