//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Form2.h"
#include "Form1.h"
#include "DragDropUtils.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmForm2 *frmForm2;
//---------------------------------------------------------------------------

/*
	Constructor
*/
__fastcall TfrmForm2::TfrmForm2(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------

/*
	Test to see if the dragged items can be dropped onto the list.
*/
void __fastcall TfrmForm2::lstBox1DragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
		// Make sure we are accepting from another list box only
	TListBox *lb = dynamic_cast<TListBox *>(Sender);
	if (lb)
		Accept = true;
	else
		Accept = false;
}
//---------------------------------------------------------------------------

/*
	Test to see if the dragged items can be dropped onto the list.
*/
void __fastcall TfrmForm2::lstBox2DragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
		// Make sure we are accepting from another list box only
	TListBox *lb = dynamic_cast<TListBox *>(Sender);
	if (lb)
		Accept = true;
	else
		Accept = false;
}
//---------------------------------------------------------------------------

/*
	This list box is copying items from another list box and appending them
	to the end of the current list. It doesn't matter where the items are
	dropped, as they will always be appended to the end.
*/
void __fastcall TfrmForm2::lstBox1DragDrop(TObject *Sender, TObject *Source, int X, int Y)
{
	AddCopyItems((TListBox *)Sender, (TListBox *)Source);
}
//---------------------------------------------------------------------------

/*
	This list box is copying items from another list box and inserting them
	at the drop point.
*/
void __fastcall TfrmForm2::lstBox2DragDrop(TObject *Sender, TObject *Source, int X, int Y)
{
	InsertCopyItems((TListBox *)Sender, (TListBox *)Source, X, Y);
}
//---------------------------------------------------------------------------


