//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ImgList.hpp>
#include <Menus.hpp>
//---------------------------------------------------------------------------
class TfrmMain : public TForm
{
__published:	// IDE-managed Components
	TListView *lstFiles;
	TToolBar *ToolBar1;
	TImageList *lstSmallImages;
	TImageList *lstBigImages;
	TToolButton *btnDetails;
	TToolButton *btnList;
	TToolButton *btnSmallIcons;
	TToolButton *btnBigIcons;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall lstFilesColumnClick(TObject *Sender, TListColumn *Column);
	void __fastcall btnChangeViewClick(TObject *Sender);
	void __fastcall lstFilesDragDrop(TObject *Sender, TObject *Source, int X, int Y);
	void __fastcall lstFilesDragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept);

private:
		// Information about a file on the disk
	struct FileInfo
	{
		AnsiString name;
		AnsiString path;
		AnsiString extension;
		__int64 size;
		TDateTime date;
		bool isfolder;
	};

	FileInfo GetFileInfo(const AnsiString &Filename);
	void AddFile(const char *Filename);

		// Sorting callbacks
	void __fastcall CompareTextFields(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);
	void __fastcall CompareIntegerFields(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);
	void __fastcall CompareDateFields(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);

		// For dropping files from Windows Explorer
	void __fastcall WMDropFiles(TWMDropFiles &Message);

public:
	__fastcall TfrmMain(TComponent* Owner);

	// For dropping files from Windows Explorer
BEGIN_MESSAGE_MAP
MESSAGE_HANDLER(WM_DROPFILES, TWMDropFiles, WMDropFiles)
END_MESSAGE_MAP(TForm)

};
//---------------------------------------------------------------------------
extern PACKAGE TfrmMain *frmMain;
//---------------------------------------------------------------------------
#endif
