//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
class TfrmMain : public TForm
{
__published:	// IDE-managed Components
	TTreeView *treeWords;
	TImageList *lstImages;
	TPanel *pnlRight;
	TLabel *lblAddTopLevelNode;
	TLabel *lblAddChildNode;
	TLabel *lblWordToAdd;
	TLabel *lblNodeCount_;
	TLabel *lblNodeCount;
	TButton *btnAddTopLevelNode;
	TButton *btnAddChildNode;
	TEdit *edtWordToAdd;
	TButton *btnExpandAll;
	TButton *btnCollapseAll;
	TButton *btnPopulate;
	TButton *btnClear;
	TButton *btnSimpleDemo;
	TGroupBox *grpNodeInfo;
	TLabel *lblCaption_;
	TLabel *lblIndex_;
	TLabel *lblLevel_;
	TLabel *lblParent_;
	TLabel *lblText;
	TLabel *lblIndex;
	TLabel *lblLevel;
	TLabel *lblParent;
	TButton *btnSort;
	TButton *btnStop;
	TMemo *Memo1;
	TTimer *Timer1;
	TLabel *lblTime_;
	TLabel *lblTime;
	void __fastcall btnAddTopLevelNodeClick(TObject *Sender);
	void __fastcall btnAddChildNodeClick(TObject *Sender);
	void __fastcall btnExpandAllClick(TObject *Sender);
	void __fastcall btnCollapseAllClick(TObject *Sender);
	void __fastcall btnPopulateClick(TObject *Sender);
	void __fastcall btnClearClick(TObject *Sender);
	void __fastcall treeWordsKeyUp(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall treeWordsDragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept);
	void __fastcall treeWordsDragDrop(TObject *Sender, TObject *Source, int X, int Y);
	void __fastcall btnSimpleDemoClick(TObject *Sender);
	void __fastcall treeWordsChange(TObject *Sender, TTreeNode *Node);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall treeWordsMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall treeWordsMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall btnSortClick(TObject *Sender);
	void __fastcall btnStopClick(TObject *Sender);
	void __fastcall treeWordsDblClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall Timer1Timer(TObject *Sender);
	void __fastcall treeWordsMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);

private:
	void UpdateCount(void);
	void UpdateNodeInfo(TTreeNode *node);
	bool IsAncestorNode(TTreeNode *Ancestor, TTreeNode *Child) const;
	void MoveTreeNode(TTreeView *tv, TTreeNode *SourceNode, TTreeNode *DestNode);
	void CopyTreeNodesRec(TTreeView *tv, TTreeNode *OriginalNode,  TTreeNode *SourceNode,  TTreeNode *DestNode);

	void __fastcall WMDropFiles(TWMDropFiles &Message);
	int CatalogFiles(const AnsiString& Directory, const AnsiString& FileSpec, TTreeView* Tree, TTreeNode *parent);
	int FindFiles(const AnsiString& Directory, TStringList& FileSpecs, bool IncludeSubdirectories, TTreeView *Tree, TTreeNode *parent);

	void AddFiles(const AnsiString &Filename);
	void AddSubFiles(TTreeNode *parent, const AnsiString &Directory);
	TTreeNode *FindChild(TTreeNode *parent, const AnsiString &str);
	void AddData(TTreeNode *node, const AnsiString &path);
	void DeleteData(TTreeNode *node);
	void ClearNodes(void);

	bool AbortProcess;

public:
	__fastcall TfrmMain(TComponent* Owner);

	// For drag and drop from Windows Explorer
BEGIN_MESSAGE_MAP
MESSAGE_HANDLER(WM_DROPFILES, TWMDropFiles, WMDropFiles)
END_MESSAGE_MAP(TForm)

};
//---------------------------------------------------------------------------
extern PACKAGE TfrmMain *frmMain;
//---------------------------------------------------------------------------
#endif
