//---------------------------------------------------------------------------

#ifndef FileFindThreadH
#define FileFindThreadH
//---------------------------------------------------------------------------
#include <Classes.hpp>
//---------------------------------------------------------------------------

struct TFileFindInfo
{
	AnsiString Name;
	AnsiString Extension;
	AnsiString Path;
	TDateTime DateModified;
	__int64 Size;
	bool IsFolder;
};

// Callback types
typedef void __fastcall (__closure *CALLBACKPROC)(const TFileFindInfo& finfo, long ID);
typedef void __fastcall (__closure *COMPLETEDPROC)(long ID);

class TFileFindThread : public TThread
{
private:
	TFileFindInfo FFInfo;
	AnsiString FDirectory;
	TStringList *FFileSpecs;
	TStringList *FFileList;
	CALLBACKPROC FCallbackProc;
	COMPLETEDPROC FCompletedProc;
	long FID;
	bool FIncludeSubdirectories;

	void __fastcall CallbackProxy(void);
	void __fastcall CompletedProxy(void);
	int CatalogFiles(const AnsiString& Directory, const AnsiString& FileSpec, TStringList& List);
	int FindFiles(const AnsiString& Directory, TStringList& FileSpecs, TStringList& List, bool IncludeSubdirectories);
	void __fastcall OnThreadTerminate(TObject *Sender);

protected:
	void __fastcall Execute();

		// Settors
	void SetCallbackProc(CALLBACKPROC callback);
	void SetCompletedProc(COMPLETEDPROC callback);
	void SetDirectory(const AnsiString& directory);
	void SetFileList(TStringList* filelist);
	void SetFileSpecs(TStringList* filespecs);
	void SetID(long ID);
	void SetIncludeSubdirectories(bool Include);

public:
	__fastcall TFileFindThread(void);  // constructor (default)
	__fastcall ~TFileFindThread(void); // destructor

		// Properties (see references for more information about properties)
	__property AnsiString Directory = {read=FDirectory, write=SetDirectory};
	__property TStringList* FileSpecs = {read=FFileSpecs, write=SetFileSpecs};
	__property TStringList* FileList = {read=FFileList, write=SetFileList};
	__property CALLBACKPROC CallbackProc = {read=FCallbackProc, write=SetCallbackProc};
	__property COMPLETEDPROC CompletedProc = {read=FCompletedProc, write=SetCompletedProc};
	__property long ID = {read=FID, write=SetID};
	__property bool IncludeSubdirectories = {read=FIncludeSubdirectories, write=SetIncludeSubdirectories};
};

//---------------------------------------------------------------------------
#endif

