//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "FileFindThread.h"
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <ImgList.hpp>

//---------------------------------------------------------------------------
class TfrmMain : public TForm
{
__published:	// IDE-managed Components
	TStatusBar *barStatus;
	TListView *lstFiles;
	TPanel *pnlControls;
	TLabel *lblFileSpecs_;
	TLabel *lblCount;
	TLabel *lblCount_;
	TComboBox *lstPath1;
	TComboBox *lstPath2;
	TComboBox *lstPath3;
	TButton *btnStart;
	TButton *btnStop1;
	TCheckBox *chkShowOutput;
	TComboBox *lstFileSpecs;
	TImageList *lstSmallImages;
	TButton *btnStop2;
	TButton *btnStop3;
	TButton *btnSuspend1;
	TButton *btnSuspend2;
	TButton *btnSuspend3;
	TButton *btnStart1;
	TButton *btnStart2;
	TButton *btnStart3;
	TButton *btnStopAll;
	TLabel *lblCount1;
	TLabel *lblCount2;
	TLabel *lblCount3;
	TCheckBox *chkRecurseSubdirectories;
	TPanel *pnlState1;
	TPanel *pnlState2;
	TPanel *pnlState3;
	TCheckBox *chkCallbackForEachFile;
	TComboBox *lstPriority1;
	TComboBox *lstPriority2;
	TComboBox *lstPriority3;
	TLabel *lblThreadPriority_;
	TLabel *lblStatus_;
	TLabel *lblPathsToSearch_;
	TLabel *lblFileCount_;
	TLabel *lblInteractiveControls_;
	TButton *btnSuspendAll;
	TRadioGroup *grpFolderShellExecuteVerb;
	TRadioGroup *grpFileShellExecuteVerb;
	void __fastcall btnStartClick(TObject *Sender);
	void __fastcall btnResumeClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall lstFilesColumnClick(TObject *Sender, TListColumn *Column);
	void __fastcall btnSuspendClick(TObject *Sender);
	void __fastcall btnStopClick(TObject *Sender);
	void __fastcall btnStopAllClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall lstFilesDblClick(TObject *Sender);
	void __fastcall FormKeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall lstFilesSelectItem(TObject *Sender, TListItem *Item, bool Selected);
	void __fastcall btnSuspendAllClick(TObject *Sender);
private:
		// Callback methods
	void __fastcall ProcessFile(const TFileFindInfo& FInf, long ID);
	void __fastcall ThreadCompleted(long ID);

	int FFileCount;
	TFileFindThread *FThreads[3];
	bool FReverseSortOrder[5];
	int FThreadCount[3];

	TPanel *FStatePanels[3];
	TLabel *FCountLabels[3];
	TStringList *FFileList[3];
	TComboBox *FPriorityList[3];

		// Methods for sorting the columns in the list view
	int __fastcall CompareTextFields(const AnsiString& Item1, const AnsiString& Item2);
	int __fastcall CompareIntegerFields(int Item1, int Item2);
	int __fastcall CompareDateFields(const TDateTime& Item1, const TDateTime& Item2);
	void __fastcall CompareNameField(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);
	void __fastcall ComparePathField(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);
	void __fastcall CompareSizeField(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);
	void __fastcall CompareTypeField(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);
	void __fastcall CompareDateField(TObject *Sender, TListItem* Item1, TListItem* Item2, int Data, int& Compare);

	void AddFile(const TFileFindInfo& FInfo, long ID);
	void PutFilesOnClipboard(TStringList* files);
	void CopySelectedToClipboard(void);

public:
	__fastcall TfrmMain(TComponent* Owner);
	__fastcall ~TfrmMain(void);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmMain *frmMain;
//---------------------------------------------------------------------------
#endif
